/*
 *  nfs.h -- header file for nfs server
 *
 *  Author:
 *      See-Mong Tan, 6/12/88
 *  Modified by:
 *	Rich Braun @ Kronos, 2/15/91
 *  Revision history:
 *  
 * $Log: nfs.h_v $
 * Revision 1.5  1991/05/13  17:52:17  richb
 * Release 3.2.
 *
 * Revision 1.4  1991/04/11  20:42:53  richb
 * Release 3.1.
 *
 * Revision 1.3  1991/03/15  22:42:02  richb
 * Changed revision date.
 *
 */

/* $Id: nfs.h_v 1.5 1991/05/13 17:52:17 richb Exp $ */

#define VERSION_NUM "3.2"
#define VERSION_DATE "13 May 91"

#define NFS_PROGRAM ((u_long) 100003)
#define NFS_VERSION ((u_long) 2)
#define NFS_PORT 2049

/* procedure definitions for version two of NFS protocol */
#define NFS_NULL 0
#define NFS_GETATTR 1
#define NFS_SETATTR 2
#define NFS_ROOT 3		/* not supported */
#define NFS_LOOKUP 4
#define NFS_READLINK 5		/* not supported */
#define NFS_READ 6
#define NFS_WRITECACHE 7	/* not supported */
#define NFS_WRITE 8
#define NFS_CREATE 9
#define NFS_REMOVE 10
#define NFS_RENAME 11
#define NFS_LINK 12		/* not supported in DOS */
#define NFS_SYMLINK 13		/* not supported in DOS */
#define NFS_MKDIR 14
#define NFS_RMDIR 15
#define NFS_READDIR 16
#define NFS_STATFS 17

  /* initializes NFS server */
extern bool_t nfs_init();

/* NFS server procedures */
  /* does nothing */
extern void nfs_null();
  /* get file attributes */
extern void nfs_getattr();
  /* set file attributes */
extern void nfs_setattr();
  /* reads a file */
extern void nfs_read();
  /* writes a file */
extern void nfs_write();
  /* file system status */
extern void nfs_statfs();
  /* read directory */
extern void nfs_readdir();
  /* directory lookup */
extern void nfs_lookup();
  /* create file */
extern void nfs_create();
  /* make a directory */
extern void nfs_mkdir();
  /* remove a file */
extern void nfs_remove();
  /* remove a directory */
extern void nfs_rmdir();
  /* rename a file */
extern void nfs_rename();
  /* link a file */
extern void nfs_link();
  /* create symbolic link */
extern void nfs_symlink();

/* error routines */
  /* write when file system is read only */
extern void nfserr_readonlyfs();
  /* call was an error */
extern void nfs_error();

/* imported from unfs.h -- SUN user level NFS file server */

/* %W% %E% UNFSSRC */

/*
 * Copyright (c) 1986 Sun Microsystems, Inc.
 */

#define	NFS_MAXDATA	1024
#define RD_SIZ		NFS_MAXDATA
#define WR_SIZ		NFS_MAXDATA
/* path and filename length parameters */
#define	NFS_MAXNAMLEN	255
#define	NFS_MAXPATHLEN	512

/*
 * NFS mount option flags
 * WARNING: These must not overlap the mount flags in vfs.h!
 */
#define	NFSMNT_SOFT	0x010000	/* soft mount (hard is default) */
#define	NFSMNT_WSIZE	0x020000	/* set write size */
#define	NFSMNT_RSIZE	0x040000	/* set read size */

/*
 * Error status
 * Should include all possible net errors.
 * For now we just cast errno into an enum nfsstat.
 */
enum nfsstat {
	NFS_OK = 0,			/* no error */
	NFSERR_PERM=EPERM,		/* Not owner */
	NFSERR_NOENT=ENOENT,		/* No such file or directory */
	NFSERR_IO=EIO,			/* I/O error */
	NFSERR_NXIO=ENXIO,		/* No such device or address */
	NFSERR_ACCES=EACCES,		/* Permission denied */
	NFSERR_EXIST=EEXIST,		/* File exists */
	NFSERR_NODEV=ENODEV,		/* No such device */
	NFSERR_NOTDIR=ENOTDIR,		/* Not a directory*/
	NFSERR_ISDIR=EISDIR,		/* Is a directory */
	NFSERR_FBIG=EFBIG,		/* File too large */
	NFSERR_NOSPC=ENOSPC,		/* No space left on device */
	NFSERR_ROFS=EROFS,		/* Read-only file system */
	NFSERR_NAMETOOLONG=ENAMETOOLONG,/* File name too long */
	NFSERR_NOTEMPTY=ENOTEMPTY,	/* Directory not empty */
	NFSERR_DQUOT=EDQUOT,		/* Disc quota exceeded */
	NFSERR_STALE=ESTALE,		/* Stale NFS file handle */
	NFSERR_WFLUSH,			/* write cache flushed */
	NFSERR_INVAL=EINVAL		/* invalid parameter */
};
#define	puterrno(error)		((enum nfsstat)error)
#define	geterrno(status)	((int)status)

/*
 * File types
 */
enum nfsftype {
	NFNON = 0,
	NFREG = 1,		/* regular file */
	NFDIR = 2,		/* directory */
	NFBLK = 3,		/* block special */
	NFCHR = 4,		/* character special */
	NFLNK = 5		/* symbolic link */
};

/*
 * Size of an fhandle in bytes
 */
#define	NFS_FHSIZE	32

/*
 * File access handle
 * This structure is supposed to be opaque from the client side.
 * It is handed out by a server for the client to use in further
 * file transactions.
 */
struct fhs {
	dev_t	fh_fsid;	 		/* filesystem id */
	u_long	fh_fno;				/* file number */
	time_t	fh_fgen;			/* file generation */
						/* fh_fgen not used in SOS */
};

/* the size of fhs varies between machines, and the FHANDLE can
 * be at most 32 bytes.  This means that the length of the
 * path name must vary.  This is invisible from the client
 * side.  It is only to keep the code clean.
 */
#define FH_PN	NFS_FHSIZE - sizeof(struct fhs)

typedef struct {
	struct fhs f;				/* file itself */
	struct fhs p;				/* parent file */
	char	fh_pn[FH_PN];			/* pathname */
} fhandle_t;

/* pcomp_t not used in SOS */
/*
 * Component name
 * This structure contains the component in a pathname.
 */
typedef struct {
	char	p_comp[NFS_MAXNAMLEN+1];	/* component name */
} pcomp_t;

/* pname_t not used in SOS */
/*
 * Pathname
 * This structure contains the pathname to a file on the server side.
 * It is mapped from the file handle.
 */
typedef struct {
	char    p_name[NFS_MAXPATHLEN];	/* pathname */
} pname_t;

/*
 * Arguments to remote write and writecache
 */
struct nfswriteargs {
	fhandle_t	wa_fhandle;	/* handle for file */
	u_long		wa_begoff;	/* beginning byte offset in file */
	u_long		wa_offset;      /* current byte offset in file */
	u_long		wa_totcount;    /* total write count (to this offset)*/
	u_long		wa_count;	/* size of this write */
	char		*wa_data;	/* data to write (up to NFS_MAXDATA) */
};


/*
 * File attributes
 */
struct nfsfattr {
	enum nfsftype	na_type;	/* file type */
	u_long		na_mode;	/* protection mode bits */
	u_long		na_nlink;	/* # hard links */
	u_long		na_uid;		/* owner user id */
	u_long		na_gid;		/* owner group id */
	u_long		na_size;	/* file size in bytes */
	u_long		na_blocksize;	/* prefered block size */
	u_long		na_rdev;	/* special device # */
	u_long		na_blocks;	/* Kb of disk used by file */
	u_long		na_fsid;	/* device # */
	u_long		na_nodeid;	/* inode # */
	struct timeval	na_atime;	/* time of last access */
	struct timeval	na_mtime;	/* time of last modification */
	struct timeval	na_ctime; 	/* time of last change */
};

/*
 * Arguments to remote read
 */
struct nfsreadargs {
	fhandle_t	ra_fhandle;	/* handle for file */
	u_long		ra_offset;	/* byte offset in file */
	u_long		ra_count;	/* immediate read count */
	u_long		ra_totcount;	/* total read count (from this offset)*/
};

/*
 * Status OK portion of remote read reply
 */
struct nfsrrok {
	struct nfsfattr	rrok_attr;	/* attributes, need for pagin*/
	u_long		rrok_count;	/* bytes of data */
	char		*rrok_data;	/* data (up to NFS_MAXDATA bytes) */
	struct buf	*rrok_bp;	/* buffer pointer for bread */
	struct vnode	*rrok_vp;	/* vnode assoc. with buffer */
};

/*
 * Reply from remote read
 */
struct nfsrdresult {
	enum nfsstat	rr_status;		/* status of read */
	int		rr_bufsize;		/* bytes allocated for buf */
	union {
		struct nfsrrok	rr_ok_u;	/* attributes, need for pagin*/
	} rr_u;
};
#define	rr_ok		rr_u.rr_ok_u
#define	rr_attr		rr_u.rr_ok_u.rrok_attr
#define	rr_count	rr_u.rr_ok_u.rrok_count
#define	rr_data		rr_u.rr_ok_u.rrok_data
#define rr_bp		rr_u.rr_ok_u.rrok_bp
#define rr_vp		rr_u.rr_ok_u.rrok_vp


/*
 * File attributes which can be set
 */
struct nfssattr {
	u_long		sa_mode;	/* protection mode bits */
	u_long		sa_uid;		/* owner user id */
	u_long		sa_gid;		/* owner group id */
	u_long		sa_size;	/* file size in bytes */
	struct timeval	sa_atime;	/* time of last access */
	struct timeval	sa_mtime;	/* time of last modification */
};


/*
 * Reply status with file attributes
 */
struct nfsattrstat {
	enum nfsstat	ns_status;		/* reply status */
	union {
		struct nfsfattr ns_attr_u;	/* NFS_OK: file attributes */
	} ns_u;
};
#define	ns_attr	ns_u.ns_attr_u


/*
 * NFS_OK part of read sym link reply union
 */
struct nfssrok {
	u_long	srok_count;	/* size of string */
	char	*srok_data;	/* string (up to NFS_MAXPATHLEN bytes) */
};

/*
 * Result of reading symbolic link
 */
struct nfsrdlnres {
	enum nfsstat	rl_status;		/* status of symlink read */
	union {
		struct nfssrok	rl_srok_u;	/* name of linked to */
	} rl_u;
};
#define	rl_srok		rl_u.rl_srok_u
#define	rl_count	rl_u.rl_srok_u.srok_count
#define	rl_data		rl_u.rl_srok_u.srok_data


/*
 * Arguments to readdir
 */
struct nfsrddirargs {
	fhandle_t rda_fh;	/* directory handle */
	u_long rda_offset;	/* offset in directory (opaque) */
	u_long rda_count;	/* number of directory bytes to read */
};

/*
 * NFS_OK part of readdir result
 */
struct nfsrdok {
	u_long	rdok_offset;		/* next offset (opaque) */
	u_long	rdok_size;		/* size in bytes of entries */
	bool_t	rdok_eof;		/* true if last entry is in result*/
	struct	udirect *rdok_entries;	/* variable number of entries */
};

/*
 * Readdir result
 */
struct nfsrddirres {
	u_long		rd_bufsize;	/* size of client request (not xdr'ed)*/
	enum nfsstat	rd_status;
	union {
		struct nfsrdok rd_rdok_u;
	} rd_u;
};
#define	rd_rdok		rd_u.rd_rdok_u
#define	rd_offset	rd_u.rd_rdok_u.rdok_offset
#define	rd_size		rd_u.rd_rdok_u.rdok_size
#define	rd_eof		rd_u.rd_rdok_u.rdok_eof
#define	rd_entries	rd_u.rd_rdok_u.rdok_entries


/*
 * Arguments for directory operations
 */
struct nfsdiropargs {
	fhandle_t	da_fhandle;	/* directory file handle */
	char		*da_name;	/* name (up to NFS_MAXNAMLEN bytes) */
};

/*
 * NFS_OK part of directory operation result
 */
struct  nfsdrok {
	fhandle_t	drok_fhandle;	/* result file handle */
	struct nfsfattr	drok_attr;	/* result file attributes */
};

/*
 * Results from directory operation 
 */
struct  nfsdiropres {
	enum nfsstat	dr_status;	/* result status */
	union {
		struct  nfsdrok	dr_drok_u;	/* NFS_OK result */
	} dr_u;
};
#define	dr_drok		dr_u.dr_drok_u
#define	dr_fhandle	dr_u.dr_drok_u.drok_fhandle
#define	dr_attr		dr_u.dr_drok_u.drok_attr

/*
 * arguments to setattr
 */
struct nfssaargs {
	fhandle_t	saa_fh;		/* fhandle of file to be set */
	struct nfssattr	saa_sa;		/* new attributes */
};

/*
 * arguments to create and mkdir
 */
struct nfscreatargs {
	struct nfsdiropargs	ca_da;	/* file name to create and parent dir */
	struct nfssattr		ca_sa;	/* initial attributes */
};

/*
 * arguments to link
 */
struct nfslinkargs {
	fhandle_t		la_from;	/* old file */
	struct nfsdiropargs	la_to;		/* new file and parent dir */
};

/*
 * arguments to rename
 */
struct nfsrnmargs {
	struct nfsdiropargs rna_from;	/* old file and parent dir */
	struct nfsdiropargs rna_to;	/* new file and parent dir */
};

/*
 * arguments to symlink
 */
struct nfsslargs {
	struct nfsdiropargs	sla_from;	/* old file and parent dir */
	char			*sla_tnm;	/* new name */
	struct nfssattr		sla_sa;		/* attributes */
};

/*
 * NFS_OK part of statfs operation
 */
struct nfsstatfsok {
	u_long fsok_tsize;	/* preferred transfer size in bytes */
	u_long fsok_bsize;	/* fundamental file system block size */
	u_long fsok_blocks;	/* total blocks in file system */
	u_long fsok_bfree;	/* free blocks in fs */
	u_long fsok_bavail;	/* free blocks avail to non-superuser */
};

/*
 * Results of statfs operation
 */
struct nfsstatfs {
	enum nfsstat	fs_status;	/* result status */
	union {
		struct	nfsstatfsok fs_fsok_u;	/* NFS_OK result */
	} fs_u;
};
#define	fs_fsok		fs_u.fs_fsok_u
#define	fs_tsize	fs_u.fs_fsok_u.fsok_tsize
#define	fs_bsize	fs_u.fs_fsok_u.fsok_bsize
#define	fs_blocks	fs_u.fs_fsok_u.fsok_blocks
#define	fs_bfree	fs_u.fs_fsok_u.fsok_bfree
#define	fs_bavail	fs_u.fs_fsok_u.fsok_bavail

/*
 * XDR routines for handling structures defined above
 */
bool_t xdr_attrstat();
bool_t xdr_creatargs();
bool_t xdr_diropargs();
bool_t xdr_diropres();
bool_t xdr_drok();
bool_t xdr_fattr();
bool_t xdr_fhandle();
bool_t xdr_linkargs();
bool_t xdr_rddirargs();
bool_t xdr_putrddirres();
bool_t xdr_getrddirres();
bool_t xdr_rdlnres();
bool_t xdr_rdresult();
bool_t xdr_readargs();
bool_t xdr_rnmargs();
bool_t xdr_rrok();
bool_t xdr_saargs();
bool_t xdr_sattr();
bool_t xdr_slargs();
bool_t xdr_srok();
bool_t xdr_timeval();
bool_t xdr_writeargs();
bool_t xdr_statfs();

